VERSION 5.00
Object = "{3A6F7F80-45E5-11D4-AC3E-ADBCE8B30410}#1.0#0"; "VSRpt7.ocx"
Object = "{A8561640-E93C-11D3-AC3B-CE6078F7B616}#1.0#0"; "VSPRINT7.ocx"
Begin VB.UserControl SPA_Preview 
   ClientHeight    =   9705
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15255
   ScaleHeight     =   9705
   ScaleWidth      =   15255
   Begin VB.Frame fra_Detail 
      BorderStyle     =   0  'None
      Height          =   9615
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   15255
      Begin VB.TextBox txt_SPD_ID 
         BackColor       =   &H80000004&
         Enabled         =   0   'False
         Height          =   285
         Left            =   13200
         TabIndex        =   2
         Text            =   "SPD_ID"
         Top             =   120
         Width           =   1935
      End
      Begin VSPrinter7LibCtl.VSPrinter vsp_VSPrinter 
         Height          =   9615
         Left            =   0
         TabIndex        =   1
         Top             =   0
         Width           =   12975
         _cx             =   22886
         _cy             =   16960
         Appearance      =   1
         BorderStyle     =   1
         Enabled         =   -1  'True
         MousePointer    =   0
         BackColor       =   -2147483643
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Arial"
            Size            =   11.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty HdrFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         _ConvInfo       =   1
         AutoRTF         =   -1  'True
         Preview         =   -1  'True
         DefaultDevice   =   0   'False
         PhysicalPage    =   -1  'True
         AbortWindow     =   -1  'True
         AbortWindowPos  =   0
         AbortCaption    =   "Printing..."
         AbortTextButton =   "Cancel"
         AbortTextDevice =   "on the %s on %s"
         AbortTextPage   =   "Now printing Page %d of"
         FileName        =   ""
         MarginLeft      =   1440
         MarginTop       =   1440
         MarginRight     =   1440
         MarginBottom    =   1440
         MarginHeader    =   0
         MarginFooter    =   0
         IndentLeft      =   0
         IndentRight     =   0
         IndentFirst     =   0
         IndentTab       =   720
         SpaceBefore     =   0
         SpaceAfter      =   0
         LineSpacing     =   100
         Columns         =   1
         ColumnSpacing   =   180
         ShowGuides      =   2
         LargeChangeHorz =   300
         LargeChangeVert =   300
         SmallChangeHorz =   30
         SmallChangeVert =   30
         Track           =   0   'False
         ProportionalBars=   -1  'True
         Zoom            =   52.2707034728406
         ZoomMode        =   3
         ZoomMax         =   400
         ZoomMin         =   10
         ZoomStep        =   25
         EmptyColor      =   -2147483636
         TextColor       =   0
         HdrColor        =   0
         BrushColor      =   0
         BrushStyle      =   0
         PenColor        =   0
         PenStyle        =   0
         PenWidth        =   0
         PageBorder      =   0
         Header          =   ""
         Footer          =   ""
         TableSep        =   "|;"
         TableBorder     =   7
         TablePen        =   0
         TablePenLR      =   0
         TablePenTB      =   0
         NavBar          =   3
         NavBarColor     =   -2147483633
         ExportFormat    =   0
         URL             =   ""
         Navigation      =   3
         NavBarMenuText  =   "Whole &Page|Page &Width|&Two Pages|Thumb&nail"
      End
      Begin Project1.ArmCombobox cbo_templates 
         Height          =   345
         Left            =   13080
         TabIndex        =   3
         Top             =   765
         Width           =   2130
         _ExtentX        =   3757
         _ExtentY        =   609
      End
      Begin Project1.ToolbarControl tlb_main 
         Height          =   690
         Left            =   13080
         TabIndex        =   4
         Top             =   8880
         Width           =   1770
         _ExtentX        =   3122
         _ExtentY        =   1217
      End
      Begin VSREPORTLibCtl.VSReport vsp_VSReport 
         Left            =   13080
         Top             =   2160
         _rv             =   700
         _rx             =   237190980
         ReportName      =   ""
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Arial"
            Size            =   9
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         OnOpen          =   ""
         OnClose         =   ""
         OnNoData        =   ""
         OnPage          =   ""
         OnError         =   ""
         MaxPages        =   0
         DoEvents        =   -1  'True
         BeginProperty Layout {8F5A70A3-B6D3-11D3-9A1F-800A5BACB530} 
            Width           =   0
            MarginLeft      =   1440
            MarginTop       =   1440
            MarginRight     =   1440
            MarginBottom    =   1440
            Columns         =   1
            ColumnLayout    =   0
            Orientation     =   0
            PageHeader      =   0
            PageFooter      =   0
            PictureAlign    =   7
            PictureShow     =   1
            PaperSize       =   0
         EndProperty
         BeginProperty DataSource {8F5A70A1-B6D3-11D3-9A1F-800A5BACB530} 
            ConnectionString=   ""
            RecordSource    =   ""
            Filter          =   ""
            MaxRecords      =   0
         EndProperty
         GroupCount      =   0
         SectionCount    =   5
         BeginProperty Section0 {E5849A61-ADD9-11D3-BDEB-000000000000} 
            Name            =   "Detail"
            Visible         =   0   'False
            Height          =   0
            CanGrow         =   -1  'True
            CanShrink       =   0   'False
            KeepTogether    =   -1  'True
            ForcePageBreak  =   0
            BackColor       =   16777215
            Repeat          =   0   'False
            OnFormat        =   ""
            OnPrint         =   ""
         EndProperty
         BeginProperty Section1 {E5849A61-ADD9-11D3-BDEB-000000000000} 
            Name            =   "Header"
            Visible         =   0   'False
            Height          =   0
            CanGrow         =   -1  'True
            CanShrink       =   0   'False
            KeepTogether    =   -1  'True
            ForcePageBreak  =   0
            BackColor       =   16777215
            Repeat          =   0   'False
            OnFormat        =   ""
            OnPrint         =   ""
         EndProperty
         BeginProperty Section2 {E5849A61-ADD9-11D3-BDEB-000000000000} 
            Name            =   "Footer"
            Visible         =   0   'False
            Height          =   0
            CanGrow         =   -1  'True
            CanShrink       =   0   'False
            KeepTogether    =   -1  'True
            ForcePageBreak  =   0
            BackColor       =   16777215
            Repeat          =   0   'False
            OnFormat        =   ""
            OnPrint         =   ""
         EndProperty
         BeginProperty Section3 {E5849A61-ADD9-11D3-BDEB-000000000000} 
            Name            =   "Page Header"
            Visible         =   0   'False
            Height          =   0
            CanGrow         =   -1  'True
            CanShrink       =   0   'False
            KeepTogether    =   -1  'True
            ForcePageBreak  =   0
            BackColor       =   16777215
            Repeat          =   0   'False
            OnFormat        =   ""
            OnPrint         =   ""
         EndProperty
         BeginProperty Section4 {E5849A61-ADD9-11D3-BDEB-000000000000} 
            Name            =   "Page Footer"
            Visible         =   0   'False
            Height          =   0
            CanGrow         =   -1  'True
            CanShrink       =   0   'False
            KeepTogether    =   -1  'True
            ForcePageBreak  =   0
            BackColor       =   16777215
            Repeat          =   0   'False
            OnFormat        =   ""
            OnPrint         =   ""
         EndProperty
         FieldCount      =   0
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Available templates:"
         Height          =   375
         Index           =   0
         Left            =   13095
         TabIndex        =   5
         Tag             =   "lbl_AvailableTemplates"
         Top             =   480
         Width           =   2040
      End
   End
End
Attribute VB_Name = "SPA_Preview"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' **************************************************************************************************
' ************************************* EXTERNAL DECLARATIONS **************************************
' **************************************************************************************************
Private Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
' **************************************************************************************************

' **************************************************************************************************
' **************************************** TOOL CONSTANTS ******************************************
' **************************************************************************************************
Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_APPNAME As String = "SPA_PRINT"             ' for error log
Private Const C_SCREENNAME As String = "SPA_Print"          ' for loading screen constants
Private Const C_SCREENMODE_STACK_SIZE As Long = 5           ' size of stack for active screens
Private Const C_TOOLBARFACE_ITEM_MTNC As String = "0"
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "1"
Private Const SIFYB_CM_ERROR_MESSAGE = 8000                 ' const for base of error messages ids
Private Const C_ID_KEY = "SPA_Document"                     ' A_ID entry for new record
' ****************************************** TOOL CONSTANTS ***************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    CompFncFailed = vbObjectError + 6           ' when component function fail
    QuietException = vbObjectError + 7          ' do not display error message
    WarMsgSelectRow = vbObjectError + 8
    SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 10 ' A SQL request does not return the expected rowcount : select an item return nothing...
End Enum

Private Enum ErrMsg
    ErrMsgNone = 0
    ErrMsgMandatoryAreEmpty = SIFYB_CM_ERROR_MESSAGE + 1
    ErrMsgDuplicateOrder = SIFYB_CM_ERROR_MESSAGE + 2
    ErrMsgDuplicateLevel = SIFYB_CM_ERROR_MESSAGE + 3
    ErrMsgNumericRequired = SIFYB_CM_ERROR_MESSAGE + 5
    ErrMsgItemIsDeleted = SIFYB_CM_ERROR_MESSAGE + 19
    ErrMsgUpdateDeletedSPA = SIFYB_CM_ERROR_MESSAGE + 27
    ErrMsg_M000 = SIFYB_CM_ERROR_MESSAGE + 0                ' undefined message
    ErrMsg_M110 = SIFYB_CM_ERROR_MESSAGE + 110              'You cannot edit this SPA because the current status is not NEW.
    ErrMsg_M120 = SIFYB_CM_ERROR_MESSAGE + 120              'You cannot delete this SPA because the current Status is not NEW or SUBMITTED for approval
    ErrMsg_M130 = SIFYB_CM_ERROR_MESSAGE + 130              'You cannot email this SPA because the status is not APPROVED
    ErrMsg_M140 = SIFYB_CM_ERROR_MESSAGE + 140              'There is no SPA document template defined for this country
    ErrMsg_M160 = SIFYB_CM_ERROR_MESSAGE + 160              'You cannot submit this SPA for approval because the current status is not NEW.
    ErrMsg_M170 = SIFYB_CM_ERROR_MESSAGE + 170              'You cannot submit this SPA for approval because it contains no item lines
    ErrMsg_M190 = SIFYB_CM_ERROR_MESSAGE + 190              'You do not not have rights on this customers market
    ErrMsg_M200 = SIFYB_CM_ERROR_MESSAGE + 200              'The requestor does not have rights on this customers market
    ErrMsg_M220 = SIFYB_CM_ERROR_MESSAGE + 220              'You do not not have rights on this projects market
    ErrMsg_M230 = SIFYB_CM_ERROR_MESSAGE + 230              'The requestor does not have rights on this projects market
    ErrMsg_M240 = SIFYB_CM_ERROR_MESSAGE + 240              'The Valid from date must be less than or equal to the Valid to date
    ErrMsg_M250 = SIFYB_CM_ERROR_MESSAGE + 250              'The Valid to date must be greater than today
    ErrMsg_M260 = SIFYB_CM_ERROR_MESSAGE + 260              'The SAP Item $BI_SAP_CODE$ is not sold in the market of the customer
    ErrMsg_M270 = SIFYB_CM_ERROR_MESSAGE + 270              'The SPA requestor is not authorised to raise an SPA for SAP Item $BI_SAP_CODE$ because of authorised market restiction. Contact the SPA System administrator
    ErrMsg_M280 = SIFYB_CM_ERROR_MESSAGE + 280              'The SAP Item $BI_SAP_CODE$ is not configured in a product group for the SPA's authorisation market. Contact the SPA System administrator
    ErrMsg_M300 = SIFYB_CM_ERROR_MESSAGE + 300              'The Field $FIELD_NAME$ must be entered
    ErrMsg_M330 = SIFYB_CM_ERROR_MESSAGE + 330              'This SPA cannot be marked used because the status is not RELEASED
    ErrMsg_M340 = SIFYB_CM_ERROR_MESSAGE + 340              'This SPA must be SUBMITTED before it can be APPROVED
    ErrMsg_M360 = SIFYB_CM_ERROR_MESSAGE + 360              'Do you really want to delete this record
    ErrMsg_M370 = SIFYB_CM_ERROR_MESSAGE + 370              'This SAP item cannot appear in this SPA twice
    ErrMsg_M650 = SIFYB_CM_ERROR_MESSAGE + 650              'This SPA cannot be marked used because the status is not APPROVED


End Enum

' *************************************** USER DEFINED ERRORS **************************************

' **************************************************************************************************
' *************************************** CONTROL MEMBERS ******************************************
' **************************************************************************************************
Dim ml_U_Code As Long                   ' if this is user loging app, needed to log errors into A_Log
Dim ms_LoginName As String
Dim ms_Language_Code As String
Dim ms_CT_Code  As String               ' CT_Code to initialize cbo_template
Dim ms_Email    As String               ' Email to be included into SPA_Document
Dim ml_SPA_Id As Long                   ' backup for add new record
Dim mb_Initialized As Boolean           ' True if the component is already initialized
Dim mb_Initializing As Boolean          ' Flag of initializing
Dim mua_ActiveMode() As ArmScreenMode
Dim ms_Title As String                  ' title of user control - can be assigned as Caption to the parent form or title for printing
Dim ml_iConcurrency As Long             ' iconc of the record curently loaded
Dim ms_DecimalSeparator As String       ' decimal separator obtained from local settings
Dim ms_ThousandSeparator As String      'locale thousand separator

Dim moa_ListFieldsMandatory As Variant  ' all mandatory controls
Dim moa_ListFieldsNumeric As Variant    ' all numeric controls
Dim moa_ListFieldsToDisable() As Control            ' common disabled control

Private mo_VSPrinter As New ArmVSPRint
#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

#If LIVE = 1 Then
    Dim mo_FSO As Object
#Else
    Dim mo_FSO As Scripting.FileSystemObject
#End If

' *************************************** CONTROL MEMBERS ******************************************
Public Event OnExit()
Public Event OnItemAdd(ByVal av_Key As Variant, ByVal as_SrzFields As String)

Private Enum ArmScreenMode
    smRefreshOnly
    smMain
    smAdd
    smView
End Enum


' **************************************************************************************************
' **************************************************************************************************
' **************************************************************************************************

' mb_Initialized is a read-only property, indicates the status of the component
Public Sub MoveC(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub
Public Property Let VisibleC(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property
Public Sub Zorder()
  Call UserControl.Extender.Zorder
End Sub
Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ml_U_Code = al_U_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".U_Code(Let)")
End Property

Public Property Let LoginName(ByVal as_LoginName As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_LoginName = as_LoginName
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LoginName(Let)")
End Property

Public Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_Language_Code) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_Language_Code = as_Language_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Language(Let)")
End Property

Public Property Let EMail(as_Email As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_Email = as_Email
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".EMail(Let)")
End Property

Public Property Let CT_Code(as_CT_Code As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_CT_Code = as_CT_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".CT_Code(Let)")
End Property

Public Property Set DB(ByRef ao_Db As ArmDb)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If ao_Db Is Nothing Then Call Err.Raise(ArmErr.InvalidArgument)
    
    Set mo_Db = ao_Db
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Db(Set)")
End Property

Public Property Get Title() As String
    Title = ms_Title
End Property

Public Function Run(ByVal ae_ScrMode As SPA_Mode, ByVal av_Key As Variant) As Boolean
On Error GoTo ErrHandler
    Run = False
    Debug.Assert (mb_Initialized = True)
    
    Select Case ae_ScrMode
        Case SPA_Mode.emView
            Run = Item_ViewInit(av_Key)      ' SPD_ID
        Case SPA_Mode.emAdd
            Run = Item_AddInit(av_Key, "NEW")       ' in this case value contaitn SPA_ID
        Case SPA_Mode.emUpdate
            Run = Item_AddInit(av_Key, "PREVIEW")       ' in this case value contaitn SPA_ID
    End Select
    
    Exit Function
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Run")
End Function

Public Sub Load_A_Com()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If mo_Db Is Nothing Then Call Err.Raise(ArmErr.PropertyNotSet, "", "mo_Db")
    If Len(ms_Language_Code) < 1 Then Call Err.Raise(ArmErr.PropertyNotSet, "", "ms_Language_Code")
    
    ' get decimal separator for conversion from string to double
    ms_DecimalSeparator = Format(0, ".")
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If

    ' Set Db
    ' Call Load_A_Com
    ' Initialize toolbars
    Debug.Assert (Not mo_Db Is Nothing)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
            lo_Control.Locked = True
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_Com
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    Set mo_VSPrinter.VSPrinterRef = vsp_VSPrinter    ' reference to VSPrinter UI component
    Set mo_VSPrinter.VSReportRef = vsp_VSReport      ' reference to VSReport UI component
    
    Call mo_VSPrinter.Load_A_Com
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    ReDim Preserve mua_ActiveMode(0)
    mua_ActiveMode(UBound(mua_ActiveMode)) = ArmScreenMode.smMain

    ' init controls
    Call Components_Settings
    
    ReDim moa_ListFieldsMandatory(0 To 0) As Variant
    moa_ListFieldsMandatory(0) = Array(cbo_templates, 0)

'    ReDim moa_ListFieldsNumeric(-1 To -1) As Variant
    
    InitMandatoryLabels (moa_ListFieldsMandatory)

    Call FillControlArray(moa_ListFieldsToDisable, Array(txt_SPD_ID))
    
    Call InitComponents
    
    Call LoadLabels(UserControl.Controls, C_SCREENNAME, ms_Language_Code)
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    ' set layout
    Call InitCtrlSize
    
    mb_Initialized = True

    ' display starting face
    Call UpdateUI(ArmScreenMode.smMain)
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_Com()")
End Sub

Private Sub FillControlArray(ByRef ao_ctrlArray() As Control, ByRef ao_array As Variant)
On Error GoTo ErrHandler
    Dim ll_i As Long
    If Not IsArray(ao_array) Then
        Exit Sub
    End If
    
    ReDim ao_ctrlArray(LBound(ao_array) To UBound(ao_array)) As Control
    
    For ll_i = LBound(ao_array) To UBound(ao_array)
        Set ao_ctrlArray(ll_i) = ao_array(ll_i)
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".FillControlArray()")
End Sub

Public Sub Unload_A_Com()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Not Initialized Then Call Err.Raise(ArmErr.CPTNotInitialized)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER", "SRM_TASKPRODUCT", "SRM_ACTION", "SRM_ATTACHMENT"
            Call lo_Control.Unload_A_Com
        End Select
    Next
    Call mo_VSPrinter.Unload_A_Com
    Set mo_VSPrinter = Nothing
    
    Set mo_Db = Nothing
    Set mo_FSO = Nothing

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Unload_A_Com()")
End Sub

Private Sub Components_Settings()
On Error GoTo ErrHandler

    Call Component_SetUp(txt_SPD_ID, "SPD_Id" & SEP & "Num")
    
    Call Component_SetUp(cbo_templates, "SPTD_Code" & SEP & "SPTD_Description" & SEP & "SPDTZ_Id")
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Components_Settings")
End Sub

Private Sub Component_SetUp(ByVal ao_cpt As Object, ByVal as_Tag As String)

On Error GoTo ErrHandler
    
    ao_cpt.Tag = as_Tag
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Component_SetUp")
End Sub

Private Sub UpdateUI(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly)
On Error GoTo ErrHandler

    ' set active face
    If au_Mode <> smRefreshOnly Then
        Call pushScreenMode(au_Mode)
    End If

    tlb_Main.Redraw = False

    ' hide all frames
    fra_Detail.Visible = False

    ' we have clean screen we can display proper controls
    Select Case activeScreenMode
        Case smMain
        Case smView
            fra_Detail.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
        Case smAdd, smView
            fra_Detail.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
            ' apply toolbar setttings
            tlb_Main.ButtonVisible("H") = txt_SPD_ID.Text = "NEW"
        Case Else
            Debug.Assert (False)
    End Select
    
    tlb_Main.Redraw = True

    ' to display face immidiatelly
    UserControl.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateUI()")
End Sub

' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************
Private Sub pushScreenMode(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    If UBound(mua_ActiveMode) = C_SCREENMODE_STACK_SIZE - 1 Then
        ' move array left
        Debug.Print ("Stack is too small. Increase C_SCREENMODE_STACK_SIZE constant please.")
        Dim ll_Index As Long
        For ll_Index = 1 To UBound(mua_ActiveMode)
            mua_ActiveMode(ll_Index - 1) = mua_ActiveMode(ll_Index)
        Next
    Else
        ' allocate one more item
        ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) + 1)
    End If
    mua_ActiveMode(UBound(mua_ActiveMode)) = au_Mode
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".pushScreenMode")
End Sub

Private Property Get activeScreenMode(Optional ByVal al_fromTop As Long = 0) As ArmScreenMode
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mua_ActiveMode))
    activeScreenMode = mua_ActiveMode(UBound(mua_ActiveMode) - al_fromTop)
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".activeScreenMode(Get)")
End Property

Private Sub popScreenMode()
On Error GoTo ErrHandler
    Debug.Assert (UBound(mua_ActiveMode) >= 1)
    ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) - 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenMode")
End Sub

Private Sub popScreenModeUntil(ByVal ae_goTo As ArmScreenMode)
On Error GoTo ErrHandler
    While activeScreenMode <> ae_goTo
        Call popScreenMode
    Wend
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenModeUntil")
End Sub


Private Sub InitComponents()
'Const CL_REQUEST_TB As String = "SELECT Info FROM Toolbars_Definitions WHERE ID=$id$"
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2422, 2817, $id$"

On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    Dim ll_Cursor As Long
    Dim ll_i As Long
    
    ' main toolbar
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_Cursor, "id", TLB_SPA_PREVIEW_ID) >= 0 Then
        Call tlb_Main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_Cursor, "info"), Left(mo_Db.GetFields(ll_Cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SPA_DETAIL_ID & ") not found in DB")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    cbo_templates.FirstBlankItem = False
    cbo_templates.Request = ReplaceCommonPlaceholders(REQ_TEMPLATES_CBO)
        
    Exit Sub
ErrHandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".InitComponents()")
End Sub

Private Sub InitMandatoryLabels(ByRef av_ListFieldsMandatory As Variant)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim lo_Label As Label

    For ll_Index = 0 To UBound(av_ListFieldsMandatory)
        If av_ListFieldsMandatory(ll_Index)(1) >= 0 Then
            Set lo_Label = lbl_labels(av_ListFieldsMandatory(ll_Index)(1))
            lo_Label.FontBold = True
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitMandatoryLabels")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = ReplacePlaceHolder(as_Request, "$language_code$", SQLStr(ms_Language_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Creator$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$U_Code$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Last_Upd_User$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$CT_Code$", SQLStr(ms_CT_Code, 4))
    as_Request = ReplacePlaceHolder(as_Request, "$EMail$", SQLStr(ms_Email, 80))
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplaceCommonPlaceholders")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function
Private Sub InitCtrlSize()
On Error GoTo ErrHandler
Const c_margin As Long = 60
    ' ??????????
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitCtrlSize()")
End Sub

Private Sub LoadDataToForm(ByVal ac_Cursor As Long, ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
   
    Dim lIdx As Long, lCount As Long
    Dim ll_i As Long
    Dim lControl As Control
    Dim lValues As Variant
    Dim ls_TempTag As String
    
        lCount = aControls.Count - 1
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            ls_TempTag = lControl.Tag & SEP
                            lValues = Split(ls_TempTag, SEP)
                            If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                                Select Case lValues(1)
                                    Case "Text", "Tel", "Email"
                                        lControl.Text = mo_Db.GetFields(ac_Cursor, lValues(0))
                                    Case "Num"
                                        lControl.Text = Replace(mo_Db.GetFields(ac_Cursor, lValues(0)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                    Case "Date"
                                        If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Then
                                            lControl.Text = ""
                                        Else
                                            lControl.Text = Format(mo_Db.GetFields(ac_Cursor, lValues(0)), "dd\/mm\/yyyy")
                                        End If
                                End Select
                            End If
                    
                    Case "ARMCOMBOBOX"
                        If lControl.Tag <> "" Then
                            lValues = Split(lControl.Tag, SEP)
                            If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                                If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Or mo_Db.GetFields(ac_Cursor, lValues(0)) = "" Then
                                    Set lControl.SelectedItem = Nothing
                                Else
                                    If lControl.SearchItem(mo_Db.GetFields(ac_Cursor, lValues(0)), 0, 0, True) = False Then
                                        For ll_i = LBound(lValues) To UBound(lValues)
                                            lValues(ll_i) = mo_Db.GetFields(ac_Cursor, lValues(ll_i))
                                        Next
                                        If lControl.AddItem(lValues, True) Is Nothing Then
                                            Err.Raise 2222, "", ""
                                        End If
                                    End If
                                End If
                            End If
                        End If
                    Case "OPTIONBUTTON"
                        lValues = Split(lControl.Tag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If UCase(lValues(2)) Like UCase(mo_Db.GetFields(ac_Cursor, lValues(0))) Then
                                lControl.Value = True
                            End If
                        End If
                        
                    Case "CHECKBOX"
                        If mo_Db.GetFieldIndex(ac_Cursor, lControl.Tag) >= 0 Then
                            If UCase(mo_Db.GetFields(ac_Cursor, lControl.Tag)) Like "X" Then
                                lControl.Value = vbChecked
                            Else
                                lControl.Value = vbUnchecked
                            End If
                        End If
                        
                    Case "A_CALOCX"
                        lControl.date_courte = Format(mo_Db.GetFields(ac_Cursor, lControl.Tag), "dd\/mm\/yyyy")
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "COMMANDBUTTON"
                        'Do Nothing
                    
                    Case "ARMGRID"
                        ' LOAD GRID
                    Case "ARMPICKER"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            lControl.ItemCode = mo_Db.GetFields(ac_Cursor, lValues(0))
                            lControl.ItemDescription = mo_Db.GetFields(ac_Cursor, lValues(1))
                            If lControl.ItemCode = "0" And lControl.ItemDescription = "" Then lControl.ItemCode = ""
                        End If
                    
                    Case Else
                        Debug.Print "LoadDataToForm  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    Exit Sub

ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadDataToForm")

End Sub


' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control
    
    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim ls_Text As String
                        Dim ll_titleIndex As Long
                        
                        ls_Text = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        ll_titleIndex = InStr(1, ls_Text, SEP)
                        
                        If Not lControl.LoadConstants(ptStatic, Left(ls_Text, ll_titleIndex - 1) & SEP & "LEFT", ctTopGrid) Then
                            Call Err.Raise(CompFncFailed, "ArmGrid.LoadConstants", "Screen constant error.")
                        End If
                        
                        If Not lControl.LoadConstants(ptStatic, right(ls_Text, Len(ls_Text) - ll_titleIndex - 1), ctColumns) Then
                            Call Err.Raise(CompFncFailed, "ArmGrid.LoadConstants", "Screen constant error.")
                        End If
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "TABSTRIP"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(lLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "COMMANDBUTTON", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    ' SPECIAL INITIALIZATION
    ' Title
    If mo_Db.Find(lLabels, "FIELD_NAME", "title", , 1) >= 0 Then
        ms_Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
    End If

    Call mo_Db.Close(lLabels)

    Exit Sub

ErrHandler:
    If lLabels > 0 Then
        Call mo_Db.Close(lLabels)
    End If
    Call ErrorHandler(Extender.Name & ".LoadLabels")
End Sub

Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control Is VSReport Then
            If Not TypeOf lo_Control.Container Is SPA_Preview Then
                If ao_parent.hwnd = lo_Control.Container.hwnd Then
                    If TypeOf lo_Control Is Frame Then
                        Dim lo_aux_collection As New Collection
                        Dim ll_i As Long
                        Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                        For ll_i = 1 To lo_aux_collection.Count
                            lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                        Next
                    Else
                        Call lo_retCollection.Add(lo_Control)
                    End If
                End If
            End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetContainedControlsChain()")
End Function

' as_Name equals to Tag definition string

Private Function GetControl(ByVal ao_array As Object, ByVal as_Name As String) As Object
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_array
        If StrComp(lo_ctrl.Tag, as_Name, vbTextCompare) = 0 Then
            Set GetControl = lo_ctrl
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetControl()")
End Function

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call SetEnabledCtrl(lo_ctrl, ab_value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_value As Boolean)
On Error GoTo ErrHandler
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_value
            ao_ctrl.BackColor = IIf(ab_value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "TABSTRIP", "A_CALOCX", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX", "CHECKBOX", "IMAGECOMBO"
            ao_ctrl.Enabled = ab_value
        Case "ARMPICKER"
            ao_ctrl.Enabled = ab_value
        Case "ARMGRID"
        Case "TOOLBARCONTROL"
            ao_ctrl.Enabled = ab_value
        End Select
        
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabledCtrl()")
End Sub


' loads values from cursor into form. if cursor=0 then reset whole detail
Private Sub Item_LoadValues(ByVal as_Key As String, ByVal as_newID As String)
On Error GoTo ErrHandler
    Dim ls_req As String
    Dim ll_Cursor As Long
    mb_Initializing = True
    If as_Key <> "" Then
        
        ' load main record
        ls_req = Replace(ReplaceCommonPlaceholders(REQ_SELECT_SPD), "$SPD_Id$", as_Key, , , vbTextCompare)
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req, 1)
        
        txt_SPD_ID.Text = as_Key
        
        Call LoadDataToForm(ll_Cursor, UserControl.Controls, Me)
        
        mo_VSPrinter.SerializedString = mo_Db.GetFields(ll_Cursor, "Srz_Fields")
        ms_Email = mo_Db.GetFields(ll_Cursor, "Email")
        ml_SPA_Id = mo_Db.GetFields(ll_Cursor, "SPA_Id")
        
        ml_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")
        
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        
    Else
        ' load default values
        txt_SPD_ID.Text = as_newID
        
        ' step build template list in A100, A80
        If cbo_templates.Count = 0 Then
            Call cbo_templates.Load
        End If
    End If

    mb_Initializing = False

    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".Item_LoadValues")
End Sub


' free resources
Private Sub Item_Cleanup()
On Error GoTo ErrHandler
    mb_Initializing = True
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Cleanup")
End Sub

' clear all controls values
Private Sub Item_Clear()
On Error GoTo ErrHandler
    mb_Initializing = True
    Call ClearForm(UserControl.Controls, fra_Detail)
    ml_SPA_Id = 0
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Clear")
End Sub

' initialize view mode
Private Function Item_ViewInit(ByVal as_detailKey As Variant) As Boolean
On Error GoTo ErrHandler
    Item_ViewInit = False
    Call ResetScreen(ArmScreenMode.smView)
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(CStr(as_detailKey(0)), "")
    
    Call UpdateUI(ArmScreenMode.smView)
    
    If Not cbo_templates.SelectedItem Is Nothing Then
        If mo_VSPrinter.SerializedString <> "" Then
            Call cbo_templates_ComboItemSelected
        End If
    End If

    Item_ViewInit = True
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ViewInit")
End Function

' initialize Add mode
Private Function Item_AddInit(ByVal al_SPA_ID As Long, ByVal as_newID As String) As Boolean
On Error GoTo ErrHandler
    Item_AddInit = False
    ' clearing form
    Call ResetScreen(ArmScreenMode.smAdd)
    Call Item_Clear
    
    Call Item_LoadValues("", as_newID)
    
    Dim ll_errMsg As Long
    ll_errMsg = Item_CanAdd()
    
    If ll_errMsg <> 0 Then
        Call MsgBox(MsgText(ll_errMsg, ms_Language_Code, "#Item cannot be added."), vbInformation)
        ' move to previous screen
        Call pushScreenMode(smView)              ' only to imitate UpdateUI
        Call Item_Exit
        Exit Function
    End If
    
    Call UpdateUI(ArmScreenMode.smAdd)
    
    If cbo_templates.Count > 0 Then
            ml_SPA_Id = al_SPA_ID            ' do backup for inserting the record
            Set cbo_templates.SelectedItem = cbo_templates.ComboItems(1)
            Call cbo_templates_ComboItemSelected
        End If
    
    Item_AddInit = True
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddInit")
End Function

' adds current edited item
Private Function Item_Add() As Variant
On Error GoTo ErrHandler
Dim lb_InTran As Boolean
    lb_InTran = False

    ' check values and throw message if neccessary
    If Not Item_Check(fra_Detail) Then
        Exit Function
    End If
    
    Dim ls_newCode As String
    ' get new code
    ls_newCode = mo_Db.SQLNextID(C_ID_KEY)
    txt_SPD_ID.Text = ls_newCode
    
    Call ExecuteSQLSafe(mo_Db, "BEGIN TRAN Item_Add")
    lb_InTran = True
    
    Call Item_AddDB(ls_newCode)

    Call ExecuteSQLSafe(mo_Db, "COMMIT TRAN Item_Add")
    lb_InTran = False
    
    RaiseEvent OnItemAdd(CVar(Array(ls_newCode)), Build_SrzString(UserControl.Controls, Me))

    ' before exit we send data to printer
    If ms_Email = "" Then
        ' select printer
        If mo_VSPrinter.SelectPrinterDlg(UserControl.Parent) Then
            Call mo_VSPrinter.PrintToPrinter(Printer.DeviceName)
        End If
    End If


    Call Item_Exit
    
    Item_Add = CVar(Array(ls_newCode))
    Exit Function
ErrHandler:
    If lb_InTran Then
        Call mo_Db.ExecuteSQL("ROLLBACK TRAN Item_Add")
        lb_InTran = False
    End If
    If Err.Number = SQLBadRowAffectedCount Then
        Call MsgBox("Error occured while inserting record, please contact IT")
        Exit Function
    End If

    Call ErrorHandler(Extender.Name & ".Item_Add")
End Function

Private Sub Item_AddDB(ByVal as_code As String)
On Error GoTo ErrHandler
    Dim ls_req As String

    ' common placeholders
    ls_req = ReplaceCommonPlaceholders(REQ_INSERT_SPD)
    ls_req = ReplacePlaceHolder(ls_req, "$Srz_Fields$", SQLStr(mo_VSPrinter.SerializedString, 4000))
    ls_req = ReplacePlaceHolder(Item_ReplacePlaceholders(ls_req), "$SPA_Id$", ml_SPA_Id)
    ls_req = ReplacePlaceHolder(Item_ReplacePlaceholders(ls_req), "$Date_Sent$", IIf(ms_Email = "", SqlDate(Now), "NULL"))
    
    Call ExecuteSQLSafe(mo_Db, ls_req, 1)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddDb")
End Sub


Private Function Build_SrzStringFromControl(ByRef aControl As Control) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ls_Str As String

    Build_SrzStringFromControl = ""
                
    ls_TempTag = aControl.Tag & SEP
    lValues = Split(ls_TempTag, SEP)
    
    Select Case UCase(TypeName(aControl))
        Case "TEXTBOX"
                Select Case lValues(1)
                    Case "Text", "Date", "Tel", "Email"
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.Text
                    Case "Num"
                        ls_Str = Replace(aControl.Text, ms_ThousandSeparator, "")
                        ls_Str = Replace(ls_Str, ms_DecimalSeparator, ".")
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & ls_Str
               End Select
        
        Case "ARMCOMBOBOX"
            If Not aControl.SelectedItem Is Nothing Then
                ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.SelectedItem.Key & SEP
                ls_SrzString = ls_SrzString & lValues(1) & SEP1 & aControl.SelectedItem.GetData(1)
            Else
                ls_SrzString = ls_SrzString & lValues(0) & SEP1 & "NULL" & SEP
                ls_SrzString = ls_SrzString & lValues(1) & SEP1 & "" & SEP
            End If
        Case "OPTIONBUTTON"
            
        Case "CHECKBOX"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & IIf(aControl.Value = vbChecked, "X", "") & SEP
        
        Case "A_CALOCX"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.date_courte
            
            
        Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
            'Do Nothing
        
        Case "ARMGRID"
            ' do nothing
'            If aControl.SelectedCount > 0 Then
'                ls_SrzString = ls_SrzString & Build_SrzStringFromGridLine(aControl)
'            End If
        Case "ARMPICKER"
            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & aControl.ItemCode & SEP
            ls_SrzString = ls_SrzString & lValues(1) & SEP1 & aControl.ItemDescription
        
        Case Else
            Debug.Print "Build_SrzStringFromControl  -> " & UCase(TypeName(aControl))
    End Select

    Build_SrzStringFromControl = ls_SrzString
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromControl")
End Function


Private Function Build_SrzString(ByRef aControls As Variant, ByRef aContainer As Object) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lo_Control As CheckBox
    Dim lIdx As Long, lCount As Long
    
    Dim ls_Str As String
    Dim lControl As Control
   
    
        lCount = aControls.Count - 1
        ls_SrzString = ""
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                ls_Str = Build_SrzStringFromControl(lControl)
                If ls_Str <> "" Then
                    ls_SrzString = ls_SrzString & ls_Str & SEP
                End If
                
            End If
            Set lControl = Nothing
        Next

    ls_SrzString = Trim(ls_SrzString)
    Build_SrzString = ls_SrzString
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Build_SrzString")
End Function

Private Sub SetCheckBoxDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByRef ao_CheckBox As VB.CheckBox, Optional ByVal as_checked As String = "X")
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, as_keyField)
    If Not IsEmpty(lv_val) Then
        ao_CheckBox.Value = IIf(lv_val = as_checked, vbChecked, vbUnchecked)
    Else
        ao_CheckBox.Value = vbUnchecked
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetCheckBoxDB")
End Sub


Private Sub SetComboBoxTextDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByVal as_DescField As String, ByRef ao_Combobox As ArmCombobox, Optional ByVal ab_clearIfNotExists As Boolean = True)
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, CVar(Array(as_keyField, as_DescField)))
    If Not IsEmpty(lv_val) Then
        Debug.Assert (UBound(lv_val) = 1)
        Call SetComboBoxText(ao_Combobox, CStr(lv_val(0)), CStr(lv_val(1)))
    Else
        If ab_clearIfNotExists Or mo_Db.GetFieldIndex(al_cursor, as_keyField) <> -1 Then
            Call ao_Combobox.Clear
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxTextDB")
End Sub

' Sets combobox selected item
' Params:
' ao_ComboBox (ArmCombobox)
' as_Key (String)
' as_Desc (String)
Private Sub SetComboBoxText(ByRef ao_Combobox As ArmCombobox, ByVal as_Key As String, ByVal as_Desc As String)
On Error GoTo ErrHandler
    If Not ao_Combobox.SearchItem(as_Key) Then
        ' key not found ... set value from parameter
        If as_Key = "" Or as_Key = "0" Then     ' zero or empty string is not valid key
            Set ao_Combobox.SelectedItem = Nothing
        Else
            Call ao_Combobox.AddItem(Array(as_Key, as_Desc), True)
            ' to make vb raise event
            Call ao_Combobox.SearchItem(as_Key)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxText")
End Sub

Private Function Item_ReplacePlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    ' general
    Dim ls_ret As String
    ls_ret = ReplaceRequestByFrameData(as_Request, fra_Detail)
    
    ' default
    ls_ret = ReplacePlaceHolder(ls_ret, "$iConcurrency$", ml_iConcurrency)
    
    Item_ReplacePlaceholders = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ReplacePlaceholders")
End Function

' exits mode to main
Private Sub Item_Exit()
On Error GoTo ErrHandler
    
    ' pop last item in screen mode stack
'    Call popScreenModeUntil(smMain)
    Call popScreenMode
    
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    If activeScreenMode = smMain Then
        RaiseEvent OnExit
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Exit")
End Sub


Private Function Item_Check(ByRef ao_Container As Object) As Boolean
On Error GoTo ErrHandler
        
'    Dim lv_MsgReplaceInfo(0, 1) As String
    Dim lo_Control As Object
    Dim ls_LabelCaption As String
    Dim ll_CtrlIndex As Long
    Dim lb_Found As Boolean
    Dim lo_mandatoryField As Variant
    
    If IsArray(moa_ListFieldsMandatory) Then
    
        For Each lo_mandatoryField In moa_ListFieldsMandatory
            Set lo_Control = lo_mandatoryField(0)
            If HasContainer(lo_Control, ao_Container) Then
                If lo_mandatoryField(1) >= 0 Then
                    ls_LabelCaption = lbl_labels(lo_mandatoryField(1)).Caption
                Else
                    ls_LabelCaption = ""
                End If
                Select Case UCase(TypeName(lo_Control))
                    Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                        ' Do nothing !

                    Case "TEXTBOX"
                        If lo_Control.Visible And (lo_Control.Text = "") Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            lo_Control.SetFocus
                            Exit Function
                        End If
                    Case "ARMCHECKVIEW"
                         If lo_Control.Visible And (lo_Control.RoleList("EDIT").CheckedCount = 0) Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                          End If
                    Case "ARMGRID"
                        ' at least one non deleted row must be in grid
                    Case "ARMCHECKVIEW", "COMMANDBUTTON", "A_CALOCX", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP"
                    
                    Case "OPTIONBUTTON", "CHECKBOX"
                        'probably array of controls
                    Case "OBJECT"
                        lb_Found = False
                        For ll_CtrlIndex = 0 To lo_Control.Count - 1
                            If UCase(TypeName(lo_Control(ll_CtrlIndex))) = "CHECKBOX" Then
                                If lo_Control(ll_CtrlIndex).Value = vbChecked Then
                                    lb_Found = True
                                    Exit For
                                End If
                            ElseIf UCase(TypeName(lo_Control(ll_CtrlIndex))) = "OPTIONBUTTON" Then
                                If lo_Control(ll_CtrlIndex).Value Then
                                    lb_Found = True
                                    Exit For
                                End If
                            Else
                                ' unknown array ???
                                lb_Found = True
                                Exit For
                            End If
                        Next
                        If Not lb_Found Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Exit Function
                        End If
                    Case "ARMCOMBOBOX"
                        If lo_Control.Visible And (lo_Control.SelectedItem Is Nothing) Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                        End If
                    Case "ARMPICKER"
                        If lo_Control.Visible And (CStr(lo_Control.ItemCode) = "") Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            lo_Control.SetFocus
                            Exit Function
                        End If
                    Case "LISTVIEW"
                         If lo_Control.Visible And (GetCheckedCount(lo_Control) = 0) Then
                            Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                            Call lo_Control.SetFocus
                            Exit Function
                          End If
                    Case Else
                        Debug.Print "Item_CheckMandatory " & UCase(TypeName(lo_Control))
                End Select
            End If ' not in container
        Next
    End If
    
    ' check all numeric fields on detail
    If Not IsArray(moa_ListFieldsNumeric) Then
        Item_Check = True
        Exit Function
    End If
    
    Dim lValues As Variant
    Dim ls_Str As String, ls_TempTag As String

    For Each lo_mandatoryField In moa_ListFieldsNumeric
        Set lo_Control = lo_mandatoryField(0)
        If HasContainer(lo_Control, ao_Container) Then
            If lo_mandatoryField(1) >= 0 Then
                ls_LabelCaption = lbl_labels(lo_mandatoryField(1)).Caption
            Else
                ls_LabelCaption = ""
            End If
            
            ls_TempTag = lo_Control.Tag & SEP
            lValues = Split(ls_TempTag, SEP)
            Select Case UCase(TypeName(lo_Control))
                Case "TEXTBOX"
                     Select Case lValues(1)
                         Case "Text"     ' no chceck needed
                         Case "Date"
                             If lo_Control.Visible And Not IsDate(lo_Control.Text) Then
                                Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                                lo_Control.SetFocus
                                Exit Function
                             End If
                         Case "Num"
                            ls_Str = Replace(lo_Control.Text, ".", ms_DecimalSeparator, , , vbTextCompare)
                            If lo_Control.Visible And Not isNumeric(ls_Str) Then
                                Call MsgBox(ReplacePlaceHolder(MsgText(ErrMsg_M300, ms_Language_Code, "The field is mandatory."), "$FIELD_NAME$", ls_LabelCaption), vbInformation)
                                lo_Control.SetFocus
                                Exit Function
                             End If
                        Case "Tel"
                            Debug.Assert (False)
                        Case "Email"
                            Debug.Assert (False)
                    End Select
                
                Case "ARMCOMBOBOX", "OPTIONBUTTON", "CHECKBOX", "A_CALOCX", "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL", "ARMGRID", "ARMPICKER"
                    ' do nothing
                
                Case Else
                    Debug.Print "Item_Check  -> " & UCase(TypeName(lo_Control))
            End Select
        End If
    Next


    Item_Check = True

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Check")
End Function

Private Function GetCheckedCount(ByRef ao_Listview As MSComctlLib.ListView) As Long
On Error GoTo ErrHandler

Dim lo_item As MSComctlLib.ListItem
Dim ll_Count As Long

    ll_Count = 0
    For Each lo_item In ao_Listview.ListItems
        If lo_item.Checked Then ll_Count = ll_Count + 1
    Next
    GetCheckedCount = ll_Count
    Exit Function
ErrHandler:
    Call ErrorHandler("GetCheckedCount")
End Function

Private Sub SetFocusToCtrl(ByRef ao_ctrl As Object)
On Error GoTo ErrHandler
    If ao_ctrl.Visible Then
        ao_ctrl.SetFocus
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".SetFocusToCtrl")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LockScreen")
End Sub

Private Sub ResetScreen(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    ' apply face
    Dim lo_ctrl As Object
    Dim lIdx As Long, lCount As Long

    Select Case au_Mode
        Case smMain
            ' enable filtering a browsing
            Call SetEnabled(GetContainedControlsChain(fra_Detail), False)
            Call SetEnabledCtrl(tlb_Main, True)
            
        Case smAdd
            ' we are in Update section
            Call SetEnabled(GetContainedControlsChain(fra_Detail), True)
            
            If IsArray(moa_ListFieldsToDisable) Then
                lCount = UBound(moa_ListFieldsToDisable)
            
                For lIdx = 0 To lCount
                    Call SetEnabledCtrl(moa_ListFieldsToDisable(lIdx), False)
                Next
            End If
            Call SetEnabledCtrl(tlb_Main, True)

        Case smView
            ' we are in PreView section
            Call SetEnabled(GetContainedControlsChain(fra_Detail), False)
            Call SetEnabledCtrl(tlb_Main, True)
        
        Case Else
            Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ResetScreen()")
End Sub


Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
    HasContainer = False
    Dim lControl As Control
 
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend
 
NotFound:
    Set lControl = Nothing
    HasContainer = False
End Function
 
Private Function IsSub(ByVal av_Name As Object, ByRef aav_Names As Variant)
On Error GoTo ErrHandler
    IsSub = False
    
    Dim ll_Idx As Long
    For ll_Idx = LBound(aav_Names) To UBound(aav_Names)
    
        If av_Name Is aav_Names(ll_Idx) Then
            IsSub = True
            Exit Function
        End If
    Next ll_Idx
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsSub")
End Function

' Clear values for each control to not initiliazed
Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object, Optional ByRef aav_Except As Variant)
On Error GoTo ErrHandler
 
    'mb_internal = True
 
    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Dim lb_Process As Boolean
        lb_Process = True
        Set lControl = aControls.Item(lIdx)
        If Not IsMissing(aav_Except) Then
            If IsSub(lControl, aav_Except) Then
                lb_Process = False
            End If
        End If
        If HasContainer(lControl, aContainer) And lb_Process Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                Case "ARMCOMBOBOX"
'                    Set lControl.SelectedItem = Nothing
                    Call lControl.Clear
                Case "A_CALOCX"
                    lControl.reinit_cal
                Case "CHECKBOX"
                    lControl.Value = vbUnchecked
                Case "ARMCHECKVIEW"
                    lControl.UnCheckAll lControl.GetVisibleList
                    Dim ll_Idx As Long
                    For ll_Idx = 1 To lControl.RoleCount
                        lControl.RoleList(ll_Idx).ClearList
                    Next
                    lControl.SetVisibleList lControl.GetVisibleList
                    
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON"
 
                Case "ARMGRID"
                    lControl.ClearGrid
                Case "LISTBOX"
                    lControl.ListIndex = -1
                Case "OPTIONBUTTON"
                    lControl.Value = False
                Case "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "TOOLBARCONTROL", "LINE"
                
                Case "ARMPICKER"
                    Call lControl.Clear
                
                Case Else
                    Debug.Print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
 
        Set lControl = Nothing
    Next
 
   ' mb_internal = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearForm")
End Sub

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#End If
On Error GoTo ErrHandler
    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        Call Err.Raise(CompFncFailed, "ao_Db.ExecuteSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_Db))
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            Call Err.Raise(SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(CompFncFailed, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_Db))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler

    GetComboKey = ""
    If Not (ao_Combo.SelectedItem Is Nothing) Then
        GetComboKey = Trim(CStr(ao_Combo.SelectedItem.Key))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetComboKey")
End Function

Private Function SqlInt(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlInt = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlInt = CStr(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlInt")
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDate")
End Function

Private Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 8000) As String
On Error GoTo ErrHandler
    SQLStr = "'" & Replace(Left(as_str, IIf(Len(as_str) <= al_MaxLen, Len(as_str), al_MaxLen)), "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlStr")
End Function

' safe retieving selected item from combobox
Private Function SQLComboBoxValue(ByRef ao_Combobox As ArmCombobox, Optional ByVal as_DefaultValue As String = "NULL", Optional ByVal ab_KeyTitle As Boolean = True) As String
On Error GoTo ErrHandler
    If IsComboboxSelected(ao_Combobox) Then
        SQLComboBoxValue = "'" & IIf(ab_KeyTitle, ao_Combobox.SelectedItem.Key, ao_Combobox.SelectedItem.DisplayText) & "'"
    Else
        SQLComboBoxValue = as_DefaultValue
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLComboBoxValue")
End Function

Private Function SQLOptionButtonValue(ByRef ao_options As Object) As String
On Error GoTo ErrHandler
    SQLOptionButtonValue = ""
    Dim opt_obj As OptionButton
    For Each opt_obj In ao_options
        If opt_obj.Value Then
            SQLOptionButtonValue = opt_obj.Tag
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLOptionButtonValue")
End Function

Private Function IsComboboxSelected(ByRef as_combo As ArmCombobox) As Boolean
On Error GoTo ErrHandler
    IsComboboxSelected = False
    If Not as_combo.SelectedItem Is Nothing Then
        If Not IsEmpty(as_combo.SelectedItem.Key) Then
            IsComboboxSelected = True
        End If
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsComboboxSelected")
End Function

' ************************************************************************************

' ************************************************************************************
' **************************** REDIM FUNCTION ****************************************
' ************************************************************************************
Sub SafeRedimString(ByRef as_Array() As String, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim as_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(as_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedimString()")
End Sub

Sub SafeRedim(ByRef av_Array() As Variant, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim av_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(av_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedim()")
End Sub
' **************************** REDIM FUNCTION ****************************************

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function GetDbError(ByVal lo_Db As Object) As String
#Else
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
#End If
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetDbError()")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , "Error message: " & as_Fct)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_Code))
    ls_req = Replace(ls_req, "$APP$", SQLStr(C_APPNAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
    ls_req = Replace(ls_req, "$MSG$", SQLStr(as_logMsg, 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage()")
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Function SendMessage(ByVal as_Msg As String, Optional Buttons As VbMsgBoxStyle = vbOKOnly) As VbMsgBoxResult
On Error GoTo ErrHandler
    Call LockScreen(True)
    SendMessage = MsgBox(as_Msg, Buttons)
    Call LockScreen(False)
    Exit Function
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".SendMessage")
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_CodePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_CodePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_CodePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    mo_VSPrinter.FontName = "Arial"
    mo_VSPrinter.Charset = ll_Charset
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "VSPrinter", "VSReport"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next

    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".ChangeCharset")
End Sub


Private Function ReplacePlaceholderByControlValue(ByVal as_Request As String, ByRef ao_Control As Object) As String
On Error GoTo ErrHandler

Dim lsa_Columns() As String

    If Trim(ao_Control.Tag) = "" Then
        ReplacePlaceholderByControlValue = as_Request
        Exit Function
    End If
    
    Select Case UCase(TypeName(ao_Control))
        Case "ARMCOMBOBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If GetComboKey(ao_Control) = "" Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(GetComboKey(ao_Control)))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(ao_Control.Text))
            End If
        Case "ARMPICKER"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If (Trim(CStr(ao_Control.ItemCode)) = "") Or (CStr(ao_Control.ItemCode) = "0") Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(Trim(CStr(ao_Control.ItemCode))))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(Trim(ao_Control.ItemDescription)))
            End If
        Case "CHECKBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.Value = vbChecked Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr("X"))
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(""))
            End If
        Case "TEXTBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If UBound(lsa_Columns) > 0 Then
                
                Select Case lsa_Columns(1)
                    Case "Text", "Tel", "Email"
                        as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
                    Case "Num"
                        If ao_Control.Text = "" Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
                            Dim ls_number As String
                            ls_number = Replace(Trim(ao_Control.Text), ms_ThousandSeparator, "", , , vbTextCompare)
                            ls_number = Replace(ls_number, ms_DecimalSeparator, ".", , , vbTextCompare)
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", ls_number)
                        End If
                    Case "Date"
                        If Not IsDate(ao_Control.Text) Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(CDate(ao_Control.Text)))
                        End If
                End Select
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
            End If
        Case "A_CALOCX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(ao_Control.date_dt))
        Case "TABSTRIP"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.SelectedItem Is Nothing Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.SelectedItem.Key))
            End If
    End Select
    ReplacePlaceholderByControlValue = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholderByControlValue")
End Function

Private Function ReplaceRequestByFrameData(ByVal as_Request As String, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
   
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Frame) Then
            as_Request = ReplacePlaceholderByControlValue(as_Request, lo_Control)
        End If
    Next
    ReplaceRequestByFrameData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByFrameData")
End Function


Private Sub cbo_templates_ComboItemSelected()
On Error GoTo ErrHandler
    Static ss_oldLanguageCode As String       ' store previously selected value

    If mb_Initializing Then Exit Sub
    ' when we are in add mode and language code has changed we need to reload da too.
    If activeScreenMode = smAdd Then
        If ss_oldLanguageCode <> cbo_templates.SelectedItem.GetData(3) Then
            mo_VSPrinter.SerializedString = CreateSPASerializedString(ml_SPA_Id, cbo_templates.SelectedItem.GetData(3))
            
            ' if no data then exit sub
            If mo_VSPrinter.SerializedString = "" Then Exit Sub
            
            ss_oldLanguageCode = cbo_templates.SelectedItem.GetData(3)
        End If
    End If
    
    ' change charset
    Call Preview(cbo_templates.SelectedItem.GetData(2), cbo_templates.SelectedItem.GetData(3))
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_templates_ComboItemSelected")
End Sub

Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_Main.Enabled = False

    Select Case as_Role
            
        Case "H" 'validate mode add
            Select Case activeScreenMode
                Case ArmScreenMode.smAdd
                    Call Item_Add
                Case Else
                    Debug.Assert (False)
            End Select
        
        Case "T"
'            Call ScanControls
            Call Item_Cleanup
            Call Item_Exit
    End Select
    
    tlb_Main.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tlb_Main.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tlb_Main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select

    Exit Sub
End Sub















Public Function ScanControls() As Boolean
On Error GoTo ErrHandler
    Dim lc_Control As Control
    Dim li_Counter As Integer
    Dim ls_StringBuilder As String
    Dim ll_Index As Long
    
    For Each lc_Control In UserControl.Controls
        'label
        If TypeOf lc_Control Is Label Then
            ll_Index = -1
            On Error Resume Next
            ll_Index = lc_Control.Index
            If ll_Index = -1 Then
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
            Else
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
            End If
        End If
        'check box
        If TypeOf lc_Control Is CheckBox Then
            Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
        End If
        'tabstrip
        If TypeOf lc_Control Is TabStrip Then
            For li_Counter = 1 To lc_Control.Tabs.Count
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Tabs.Item(li_Counter))
            Next
        End If
        'option button
        If TypeOf lc_Control Is OptionButton Then
            Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
        End If
        'grid
        If TypeOf lc_Control Is ArmGrid Then
            Debug.Print (UserControl.Name & ";" & lc_Control.Tag & "_Title;E;E;;" & lc_Control.Title)
            If Not lc_Control.Cols = 0 Then
                ls_StringBuilder = ""
                For li_Counter = 0 To lc_Control.Cols - 1
                    If li_Counter = lc_Control.Cols - 1 Then
                        ls_StringBuilder = ls_StringBuilder & lc_Control.Columns(li_Counter).Title
                    Else
                        ls_StringBuilder = ls_StringBuilder & lc_Control.Columns(li_Counter).Title & SEP
                    End If
                Next
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & ls_StringBuilder)
            End If
        End If
    Next
    ScanControls = True
    
    Exit Function
ErrHandler:
    ScanControls = False
    Call ErrorHandler("ScanControls")
End Function


Private Function Item_CanAdd() As Long
On Error GoTo ErrHandler
    Item_CanAdd = 0
    
    If cbo_templates.Count = 0 Then
        Item_CanAdd = ErrMsg_M140
        Exit Function
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_CanAdd")
End Function

Private Function CheckFolderExist(ByVal as_Folder As String) As String
    Dim ls_Folder As String
        
    ls_Folder = as_Folder
    
    If right(ls_Folder, 1) <> "\" Then ls_Folder = ls_Folder & "\"
    
    If Not mo_FSO.FolderExists(ls_Folder) Then
        ls_Folder = mo_FSO.CreateFolder(ls_Folder).Path
    End If
    
    CheckFolderExist = ls_Folder
    Exit Function
ErrHandler:
    Call ErrorHandler("CheckFolderExist")
End Function

Private Function DownloadTemplate(ByVal as_DownloadFolder As String, ByVal al_SPDTZ_ID As Long) As String
On Error GoTo ErrHandler
    
    Dim ls_ret  As String
    ls_ret = ""
    
    Dim ls_zipFile As String
    ls_zipFile = as_DownloadFolder & "SPATmpZip" & al_SPDTZ_ID
    
    If mo_Db.BlobToFileSQL(ReplacePlaceHolder(REQ_TEMPLATE_DOWNLOAD, "$SPDTZ_ID$", al_SPDTZ_ID), ls_zipFile, 9) Then
    
        If mo_Db.DecompressFile(ls_zipFile, ls_zipFile & ".DIR\", True, True) Then
            ls_ret = ls_zipFile & ".DIR\" & "SPATmp.xml"
            
            If Not mo_FSO.FileExists(ls_ret) Then
                ls_ret = ""
            End If
        End If
        
    End If
    
    DownloadTemplate = ls_ret
    
    Exit Function
ErrHandler:
    Call ErrorHandler("DownloadTemplate")
End Function

Private Function Preview(ByVal al_SPDTZ_ID As Long, ByVal as_Language As String) As Boolean
On Error GoTo ErrHandler
    Preview = False
    Dim ls_downloadFolder As String
    
    ls_downloadFolder = CheckFolderExist(App.Path & "\" & C_SPATMPFOLDER)
    
    ls_downloadFolder = DownloadTemplate(ls_downloadFolder, al_SPDTZ_ID)
    
    If ls_downloadFolder <> "" Then
        ' preview
        
        mo_VSPrinter.Charset = GetCharSetFromCodePage(GetCodePageFromLanguage(mo_Db, as_Language))
        
        Call mo_VSPrinter.LoadTemplate(ls_downloadFolder, "SPA")

        Call mo_VSPrinter.PrintPreview
    
        Preview = True
    End If

    Exit Function
ErrHandler:
    Call ErrorHandler("Preview")
End Function

Private Function CreateSPASerializedString(ByVal al_SPA_ID As Long, ByVal as_SPD_language_code As String) As String
On Error GoTo ErrHandler
    Dim ls_req As String
    Dim ls_szString As String
    Dim ll_Cursor As Long
    CreateSPASerializedString = ""
    
    ' header
    ls_req = ReplacePlaceHolder(ReplacePlaceHolder(REQ_TEMPLATE_HEADER_SPA_PRINT, "$Language_Code$", "'" & as_SPD_language_code & "'"), "$SPA_Id$", al_SPA_ID)
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    ls_szString = CreateTemplateSerializedString(mo_Db, ll_Cursor)
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' items
    ls_req = ReplacePlaceHolder(ReplacePlaceHolder(REQ_TEMPLATE_ITEM_SPA_PRINT, "$Language_Code$", "'" & as_SPD_language_code & "'"), "$SPA_Id$", al_SPA_ID)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    ls_szString = ls_szString & SEP & CreateTemplateSerializedString(mo_Db, ll_Cursor)
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    CreateSPASerializedString = ls_szString
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Call ErrorHandler("CreateSPASerializedString")
End Function

Private Function CreateTemplateSerializedString(ByVal ao_Db As ArmDb, ByVal al_cursor As Long) As String
On Error GoTo ErrHandler

Dim ls_value As String
Dim ls_FieldName As String
Dim ls_SerString As String
Dim ll_FieldIdx As Long

    CreateTemplateSerializedString = ""
    
    For ll_FieldIdx = 0 To ao_Db.FieldCount(al_cursor) - 1
        ls_FieldName = ao_Db.GetFieldName(al_cursor, ll_FieldIdx)
        If ls_FieldName = "" Then Err.Raise 666, "ao_Db.GetFieldName", "Field has no name in request for serialized string"
        ls_value = ls_FieldName
        Call ao_Db.First(al_cursor)
        
        If ao_Db.EOF(al_cursor) = True Then
            ls_value = ls_value & SEP1
        Else
        
            Do While Not ao_Db.EOF(al_cursor)
                ls_value = ls_value & SEP1
                ' specific formatting
                If StrComp(ls_FieldName, "SPA_Item.SPA_Qty", vbTextCompare) = 0 Then
                    ls_value = ls_value & Trim(Replace(Format(ao_Db.GetFields(al_cursor, ll_FieldIdx), "###0.0"), ms_DecimalSeparator, "."))
                Else
                    ' generic formating
                Select Case ao_Db.GetFieldType(al_cursor, ll_FieldIdx)
                    Case DBTYPE_I4
                        ls_value = ls_value & Trim(CLng(ao_Db.GetFields(al_cursor, ll_FieldIdx)))
                    Case DBTYPE_R4, DBTYPE_R8
                        ls_value = ls_value & Trim(Replace(Format(ao_Db.GetFields(al_cursor, ll_FieldIdx), "###0.00"), ms_DecimalSeparator, "."))
                Case DBTYPE_DATE
                    ls_value = ls_value & Format(ao_Db.GetFields(al_cursor, ll_FieldIdx), "dd\/mm\/yyyy")
                Case Else
                    ls_value = ls_value & Replace(Replace(ao_Db.GetFields(al_cursor, ll_FieldIdx), SEP1, "(R)"), SEP2, "(C)")
                End Select
                End If
                Call ao_Db.Next(al_cursor)
            Loop
        End If
        
        ls_SerString = ls_SerString & IIf(ls_SerString = "", ls_value, SEP & ls_value)
    Next
    CreateTemplateSerializedString = ls_SerString
    Exit Function
ErrHandler:
    Call ErrorHandler("CreateTemplateSerializedString")
End Function


Private Sub UserControl_Resize()
On Error Resume Next

    Call fra_Detail.Move(0, 0, Extender.Width, Extender.Height)
    
    If Extender.Width - cbo_templates.Width - 100 <= 0 Then Exit Sub
    Call cbo_templates.Move(Extender.Width - cbo_templates.Width - 100)
    
    If Extender.Width - tlb_Main.Width - 200 <= 0 Then Exit Sub
    If Extender.Height - tlb_Main.Height - 400 <= 0 Then Exit Sub
    Call tlb_Main.Move(Extender.Width - tlb_Main.Width - 200, Extender.Height - tlb_Main.Height - 400)
    
    
    Call lbl_labels(0).Move(cbo_templates.Left)
    Call txt_SPD_ID.Move(cbo_templates.Left)
    If cbo_templates.Left > 60 Then
        Call vsp_VSPrinter.Move(0, 0, cbo_templates.Left - 60, tlb_Main.Top + tlb_Main.Height)
    End If
End Sub

